varying vec2 v_texCoord;
varying vec4 v_color;
varying vec3 v_R;

uniform sampler2D s_texture0;
uniform samplerCube s_texture1;

uniform float u_reflectivity;
uniform float u_alphaCurrent;

void main()
{
  vec4 reflectColor = textureCube(s_texture1, v_R);
  reflectColor.a = 0.0;
  
  vec4 color = texture2D(s_texture0, v_texCoord) * vec4(v_color.rgb,1);
  color.a = color.a * u_alphaCurrent;
  
//  gl_FragColor = mix(color, reflectColor, u_reflectivity);
  gl_FragColor = color + reflectColor*u_reflectivity;
  
  gl_FragColor.r *= gl_FragColor.a;
  gl_FragColor.g *= gl_FragColor.a;
  gl_FragColor.b *= gl_FragColor.a;
}
